﻿using System;
using Microsoft.OData;
using Microsoft.OData.Edm;
using Microsoft.OData.UriParser;
using PpmsDataService.Models;
using System.Collections.Generic;
using System.Web.Http;
using System.Web.OData.Builder;
using System.Web.OData.Extensions;
using System.Web.OData.Routing.Conventions;

namespace PpmsDataService
{
    public static class WebApiConfig
    {
        public static void Register(HttpConfiguration config)
        {

            var model = GetEdmModel();

            config.MapODataServiceRoute("odata", null, builder =>
                builder.AddService(ServiceLifetime.Singleton, sp => model)
                .AddService<IEnumerable<IODataRoutingConvention>>(ServiceLifetime.Singleton, sp => ODataRoutingConventions.CreateDefaultWithAttributeRouting("odata", config))
                .AddService<ODataUriResolver>(ServiceLifetime.Singleton, s => new AlternateKeysODataUriResolver(model))
                //.AddService<ODataUriResolver>(ServiceLifetime.Singleton, ci => new CaseInsensitiveResolver())
                //.AddService<ODataUriResolver>(ServiceLifetime.Singleton, s => new StringAsEnumResolver() { EnableCaseInsensitive = true })
                );



            //config.MapODataServiceRoute("odata", null, GetEdmModel(), new DefaultODataBatchHandler(GlobalConfiguration.DefaultServer));
            config.Count().Filter().OrderBy().Expand().Select().MaxTop(25);
            config.EnsureInitialized();

        }

        public class CaseInsensitiveResolver : ODataUriResolver
        {
            public override bool EnableCaseInsensitive
            {
                get { return true; }
                set { /* Ignore value */ }
            }


        }


        public static IEdmModel GetEdmModel()
        {
            var builder = new ODataConventionModelBuilder
            {
                Namespace = "PpmsDataService",
                ContainerName = "DefaultContainer"
            };

            builder.EntitySet<Provider>("Providers").EntityType.Select(nameof(Provider.ProviderIdentifier), nameof(Provider.Name), nameof(Provider.ProviderType));
            builder.EntitySet<ProviderCredential>("ProviderCredentials").EntityType.Select(nameof(ProviderCredential.Name), nameof(ProviderCredential.CredentialNumber));
            builder.EntitySet<Specialty>("Specialties").EntityType.Select(nameof(Specialty.SpecialtyCode), nameof(Specialty.Name), nameof(Specialty.Grouping), nameof(Specialty.Classification), nameof(Specialty.Specialization), nameof(Specialty.SpecialtyDescription));
            builder.EntitySet<ProviderSpecialty>("ProviderSpecialties").EntityType.Select(nameof(ProviderSpecialty.CodedSpecialty), nameof(ProviderSpecialty.Name), nameof(ProviderSpecialty.ialty.ialty.ialty.ialty.ialty.ialty.ialty.ialty.ialty.ialty.ialty.ialty.ialty.ialty.ialty.ialty.ia